﻿//**************************************************************************************
//
// Name: Form1
// Description: Sets the colors used for the 12 weight classification zones
//
//**************************************************************************************

using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MettlerToledo.IND780.SharedDataClient;
using MettlerToledo.IND780.Softkeys;

namespace Classify_Application
{
	public partial class Form1 : Form
	{
		private SDclient SD_client = ClassifyMain.SD_client;

		private Softkeys mySoftkeys;

		private bool CtrlKeyPressed = false;

		private ComboBox[] cbArray = new ComboBox[12];

		// shared data to store comboBox_class1 to comboBox_class12 color selection
		private string[] sdArray = {"ax0101", "ax0102", "ax0103",
								    "ax0104", "ax0105", "ax0106",
								    "ax0107", "ax0108", "ax0109",
								    "ax0110", "ax0111", "ax0112"};



		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::Form1
		* Description   :Constructor
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		public Form1()
		{
			InitializeComponent();

			if (SD_client.GetSharedDataConnectionStatus)
				this.label_connected.BackColor = Color.Lime;

			this.SoftkeysInitialization();
			this.RegisterSoftkeys();


			this.Load_ClassComboBoxSelections();
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::vScrollBar1_ValueChanged
		* Description   :The vertical scrollbar value changed event handler.  Changes the top value of panel2
		*				:to simulate vertical scrolling.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void vScrollBar1_ValueChanged(object sender, EventArgs e)
		{
			this.panel2.Top = 0 - this.vScrollBar1.Value;
			this.panel2.Refresh();
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::comboBox_classN_SelectedIndexChanged
		* Description   :Changes the color graphic when the comboBox selection changes.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void comboBox_classN_SelectedIndexChanged(object sender, EventArgs e)
		{
			string[] colors = {"class_white.bmp", "class_yellow.bmp", "class_blue.bmp",
							   "class_navy.bmp", "class_red.bmp", "class_maroon.bmp",
							   "class_orange.bmp", "class_purple.bmp", "class_lime.bmp",
							   "class_green.bmp", "class_pink.bmp", "class_light_gray.bmp",
							   "class_dark_gray.bmp", "class_magenta.bmp", "class_olive.bmp",
							   "class_teal.bmp"};

			PictureBox[] pboxes = { this.pictureBox_class1, this.pictureBox_class2, this.pictureBox_class3,
								    this.pictureBox_class4, this.pictureBox_class5, this.pictureBox_class6,
								    this.pictureBox_class7, this.pictureBox_class8, this.pictureBox_class9,
								    this.pictureBox_class10, this.pictureBox_class11, this.pictureBox_class12};

			string selectedColor = colors[((ComboBox)sender).SelectedIndex];
			PictureBox pbox = pboxes[(int)((ComboBox)sender).Tag - 1];

			pbox.Image = new Bitmap(@"Storage Card\Terminal\SKBMP\COLOR\" + selectedColor);
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::SoftkeysInitialization
		* Description   :Creates the five picture boxes and draws the softkey borders used by the softkeys
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void SoftkeysInitialization()
		{
			mySoftkeys = new Softkeys();
			mySoftkeys.AllocateSoftkeys(this, 175, @"Storage Card\Terminal\SKBMP\COLOR\");
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::Form1_Paint
		* Description   :The Form1 Paint event handler.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void Form1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			mySoftkeys.DrawSoftkeyBorders(this);
		}


		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::RegisterSoftkeys
		* Description   :Registers the softkey graphic and method used by each softkey.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void RegisterSoftkeys()
		{
			// level 0 softkeys
			mySoftkeys.LoadSoftkeys(0, 0, true, @"Storage Card\Terminal\SKBMP\COLOR\exit.bmp", (Softkeys.mySKMethodDelegate)ClassifyColorsExit);
			mySoftkeys.LoadSoftkeys(0, 4, true, @"Storage Card\Terminal\SKBMP\COLOR\ok.bmp", (Softkeys.mySKMethodDelegate)ClassifyColorsOK);

			mySoftkeys.NumberOfLevels = 1;

			mySoftkeys.DisplaySoftKeys(0);
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::ClassifyColorsExit
		* Description   :Disconnect from the shared data server and closes the form.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void ClassifyColorsExit()
		{
			//SD_client.DisconnectFromSharedDataServer();
			this.Close();
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::ClassifyColorsOK
		* Description   :Saves the colors selected for each class and then exits.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void ClassifyColorsOK()
		{
			for (int i = 0; i < cbArray.Length; i++)
			{
				int selectedIndex = this.cbArray[i].SelectedIndex;

				if (selectedIndex == -1)
					selectedIndex = 0;		// default to white

				SD_client.SetSharedData(this.sdArray[i], selectedIndex.ToString());

			}

			this.ClassifyColorsExit();
		}


		// special native code call to force the combobox to drop-down
		// when it receives the focus
		[System.Runtime.InteropServices.DllImport("coredll.dll")]
		public static extern int SendMessage(int hWnd, int msg, int wParam, IntPtr lParam);
		public const int CB_SHOWDROPDOWN = 0x14F;

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::Common_KeyUp
		* Description   :Common key-up event handler for all keys.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void Common_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyCode == Keys.ControlKey)
				this.CtrlKeyPressed = false;

			// the enter key will move the focus and scroll bar if necessary
			if (sender is ComboBox)
			{
				if (e.KeyCode == Keys.Enter)
				{
					for (int i = 0; i < this.cbArray.Length; i++)
					{
						if (this.cbArray[i].Focused)
						{
							i++;
							if (i == this.cbArray.Length)
								i = 0;
							this.vScrollBar1.Value = (i / 6) * this.vScrollBar1.Maximum; // cb 1 to 6, then 7 to 12 displayed
							this.cbArray[i].Focus();
							break;
						}
					}
				}
				else if (e.KeyCode == Keys.Right)	// use right arrow to force a dropdown
				{
					SendMessage(((ComboBox)sender).Handle.ToInt32(), CB_SHOWDROPDOWN, 1, IntPtr.Zero);
					e.Handled = true;
				}
				else if (e.KeyCode == Keys.Left)	// use left arrow to retract the dropdown
				{
					SendMessage(((ComboBox)sender).Handle.ToInt32(), CB_SHOWDROPDOWN, 0, IntPtr.Zero);
					e.Handled = true;
				}
				else
				{
					mySoftkeys.SoftkeyDispatcher((int)e.KeyCode);
				}
			}
			else
				mySoftkeys.SoftkeyDispatcher((int)e.KeyCode);
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::Common_KeyDown
		* Description   :Common key-down event handler for all keys.  Forces a key click noise.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void Common_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyCode == Keys.ControlKey)
			{
				this.CtrlKeyPressed = true;
				return;
			}
			ClassifyMain.SD_client.SetSharedData("xc0134", "1");	// key click

			if (e.KeyCode == Keys.Left || e.KeyCode == Keys.Right)	// prevent left and right keys from changing selections
				e.Handled = true;

			if (this.CtrlKeyPressed)
				e.Handled = true;			// this prevents controls such as comboBoxes from getting the key
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::Load_ClassComboBoxSelections
		* Description   :This method reads each shared data assigned to the comboBox_class comboBoxes and
		*				:sets their selected index values.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void Load_ClassComboBoxSelections()
		{
			ComboBox[] cbxArray = {this.comboBox_class1, this.comboBox_class2, this.comboBox_class3,
				                   this.comboBox_class4, this.comboBox_class5, this.comboBox_class6,
				                   this.comboBox_class7, this.comboBox_class8, this.comboBox_class9,
				                   this.comboBox_class10, this.comboBox_class11, this.comboBox_class12};

			for (int i = 0; i < cbxArray.Length; i++)
			{
				int sdValue = 0;
				string sdValueString = string.Empty;

				this.cbArray[i] = cbxArray[i];

				// load the shared data values
				sdValueString = SD_client.ReadSharedData(this.sdArray[i]);

				try
				{
					sdValue = int.Parse(sdValueString);
				}
				catch
				{
					sdValue = 0;
				}
				this.cbArray[i].SelectedIndex = sdValue;
			}
		}

	}
}